function [ut,auxt,auxt_labels]=controller_function_template(i,t,x,y,u,ts,csi,o,aux)
 
% File template for creating m-functions implementing control strategies for the Yeastsim bioprocess simulator  
%
%[ut,auxt,auxt_labels]=controller_function_template(i,t,x,y,u,ts,csi,o,aux)
%
% OUTPUT
% ut ... row vector of values of manipulated variables at time t
% auxt ... row vector of auxiliary variables for optional storage of time-varying variables and parameters of control strategies (e.g. setpoints)
%
% ut(1) ... feed flowrate (F, ml/s)
% ut(2) ... air flowrate (Fv, ml/s)  
% ut(3) ... stirrer speed (n, 1/s)
%
% auxt(1) ... auxiliary variable no. 1
% auxt(2) ... auxiliary variable no. 2
% auxt(3) ... auxiliary variable no. 3
% auxt(4) ... auxiliary variable no. 4
% auxt(5) ... auxiliary variable no. 5
%
% auxt_labels(1) ... text label for auxiliary variable no. 1
% auxt_labels(2) ... text label for auxiliary variable no. 2
% auxt_labels(3) ... text label for auxiliary variable no. 3
% auxt_labels(4) ... text label for auxiliary variable no. 4
% auxt_labels(5) ... text label for auxiliary variable no. 5
%
%
% INPUT
% i ... integer index value passed from the parent FOR loop
% t ... current time (s)
% x ... matrix of state variables
% y ... matrix of output (measured) variables
% u ... matrix of manipulated variables
% ts ... sample time (s)
% csi ... glucose concentration in the nutrient solution (feed) (mol/ml)
% o ... matrix of estimated variables by soft sensors
% aux ... matrix of auxiliary variables for optional storage of time-varying variables and parameters of control strategies (e.g. setpoints)
% Note: for the composition of the x,y,u,o,aux matrices, see help for yeast_simcon.m function
 
% Auxiliary global variable for recording the number of controller m-function executions
global citac_spusteni_reg
 
% Initialization of function output variables
ut=zeros(1,3);
auxt=zeros(1,5)*NaN;
auxt_labels={'label_auxvar1','label_auxvar2','label_auxvar3','label_auxvar 4','label_auxvar5'};
  
% Calculation of feed flowrate (ml/s)
% admissible range for model laboratory bioreactor: 00.16 ml/s (010 ml/min), in addition, the total limit for the volume of the bioreactor must be observed, see below
% ut(1)=<define calculation according to your control strategy>;
 
% Calculation of air flowrate (ml/s)
% admissible range for model laboratory bioreactor: 0250 ml/s (015 l/min)
% typically set to a constant value of 10 l/min, i.e. 167 ml/s
% ut(2)=167;
% or
% ut(2)=<define air flowrate calculation according to your control strategy>;
 
% Calculation of stirrer speed (1/s)
% admissible range for model laboratory bioreactor: 016 1/s (01000 1/min)
% typically set to a constant value of 600 1/min, i.e. 10 1/s
% ut(3)=10;
% or
% ut(3)=<define stirrer speed calculation according to your control strategy>;
  
% calculation of values of manipulated variables at time t completed
citac_spusteni_reg=citac_spusteni_reg+1;
 
% safety check against overfilling of the bioreactor
 
% maximum total allowable volume of liquid in the bioreactor (ml)
vol_max=7500;
 
cur_vol=x(i,6);
new_vol=cur_vol+ut(1)*60;
 
if new_vol>vol_max
    ut(1)=(vol_max-cur_vol)/60;
end
