clear ALL;
clear global;
close all;
clc;

% SETUP SECTION - START
%
% x0 ... initial condition at time t0
% typically x0=[cx0 0 0 0.23e-6 0 v0 0.2/3600 0 0]
% where cx0 is the initial biomass concentration (e.g. 1 g/l, i.e. 4e-5 mol/ml)
% and v0 is the initial volume (typically 5 l in a lab fermenter, i.e. 5000 ml)
% note: for the meaning of other entries of x0, see help for yeast_simcon.m function
% 
x0=[4e-5 0 0 2.3e-7 0 5000 5.5556e-5 0 0];

% csi ... concentration of glucose in the nutrient solution (mol/ml) (in a lab fermenter typically 100 g/l, i.e. 0.0033 mol/ml)
%
csi=0.0033;

% Setup of the simulation time parameters
% t0 ... start time of simulated cultivation (s)
% t1 ... end time of simulated cultivation (s)
% ts ... sampling time (s)
%
t0=0;
t1=36000;
ts=60;

% Control strategy selection
% reg=@controller_function where controller_function is the name of the m-function implementing the selected control strategy, in the form [ut,auxt,auxt_labels]=controller_function(i,t,x,y,u,ts,csi,o,aux), see the regs folder for examples
%

% reg=@regulator_feedforward_xest;
% reg=@regulator_DOCONT_v1;
% reg=@regulator_DOCONT_v2;
% reg=@regulator_DOCONT_v3;
reg=@regulator_DOCONT_v4;

% auxiliary global variable for control strategy
global citac_spusteni_reg
citac_spusteni_reg=0;

% SETUP SECTION - END


% SIMULATION SECTION - START

[yc,xc,uc,oc,auxc,auxc_labels]=yeast_simcon(t0,t1,ts,x0,csi,reg);

% SIMULATION SECTION - END


% RESULTS AND VISUALIZATION SECTION - START

tim=[t0:ts:t1]';
tim=tim./60;

% Calculation of process quality indicators
process_indicators=yield_prod_calc(tim,xc,yc,uc,csi);

% biomass yield on substrate (gX/gS)
disp('Yield (gX/gS):')
disp(process_indicators(1));

% bioprocess productivity (gX/l/h)
disp('Productivity (gX/l/h):')
disp(process_indicators(2));

% Plots of state variables
figure(1);plot(tim,xc(:,1));title('Biomass concentration (mol/ml)');xlabel('Cultivation time (min)');
figure(2);plot(tim,xc(:,2));title('Glucose concentration (mol/ml)');xlabel('Cultivation time (min)');
figure(3);plot(tim,xc(:,3));title('Ethanol concentration (mol/ml)');xlabel('Cultivation time (min)');
figure(4);plot(tim,xc(:,4));title('O2 concentration (mol/ml)');xlabel('Cultivation time (min)');
figure(5);plot(tim,xc(:,5));title('CO2 concentration (mol/ml)');xlabel('Cultivation time (min)');
figure(6);plot(tim,xc(:,6));title('Fermentation broth volume (ml)');xlabel('Cultivation time (min)');

% Plots of output (measured) variables
figure(7);plot(tim,yc(:,1));title('Ethanol mol fraction (% mol.)');xlabel('Cultivation time (min)');
figure(8);plot(tim,yc(:,2));title('O2 mol fraction - off-gas (% mol.)');xlabel('Cultivation time (min)');
figure(9);plot(tim,yc(:,3));title('CO2 mol fraction - off-gas (% mol.)');xlabel('Cultivation time (min)');
figure(10);plot(tim,yc(:,4));title('Dissolved O2 concentration (% sat.)');xlabel('Cultivation time (min)');

% Plots of manipulated variables
figure(11);plot(tim,uc(:,1));title('Feed flowrate (ml/s)');xlabel('Cultivation time (min)');
figure(12);plot(tim,uc(:,2));title('Air flowrate (ml/s)');xlabel('Cultivation time (min)');
figure(13);plot(tim,uc(:,3));title('Stirrer speed (1/s)');xlabel('Cultivation time (min)');

% Plots of estimated variables
figure(14);plot(tim,xc(:,1),'g',tim,oc(:,1),'r',tim,oc(:,2),'b');title('Biomass concentration and its estimates by soft sensors (mol/ml)');xlabel('Cultivation time (min)');

% RESULTS AND VISUALIZATION SECTION - END
