function [ut,auxt,auxt_labels]=regulator_DOCONT_v3(i,t,x,y,u,ts,csi,o,aux)

% DOCONT rule-based control strategy - variant v3 
%
% [ut,auxt,auxt_labels]=regulator_DOCONT_v3(i,t,x,y,u,ts,csi,o,aux)
%
% OUTPUT
% ut ... row vector of values of manipulated variables at time t
% auxt ... row vector of auxiliary variables for optional storage of time-varying variables and parameters of control strategies (e.g. setpoints)
%
% ut(1) ... feed flowrate (F, ml/s)
% ut(2) ... air flowrate (Fv, ml/s)  
% ut(3) ... stirrer speed (n, 1/s)
%
% auxt(1) ... auxiliary variable no. 1
% auxt(2) ... auxiliary variable no. 2
% auxt(3) ... auxiliary variable no. 3
% auxt(4) ... auxiliary variable no. 4
% auxt(5) ... auxiliary variable no. 5
%
% auxt_labels(1) ... text label for auxiliary variable no. 1
% auxt_labels(2) ... text label for auxiliary variable no. 2
% auxt_labels(3) ... text label for auxiliary variable no. 3
% auxt_labels(4) ... text label for auxiliary variable no. 4
% auxt_labels(5) ... text label for auxiliary variable no. 5
%
% INPUT
% i ... integer index value passed from the parent FOR loop
% t ... current time (s)
% x ... matrix of state variables
% y ... matrix of output (measured) variables
% u ... matrix of manipulated variables
% ts ... sample time (s)
% csi ... glucose concentration in the feed (mol/ml)
% o ... matrix of estimated variables by soft sensors
% aux ... matrix of auxiliary variables for optional storage of time-varying variables and parameters of control strategies (e.g. setpoints)
% Note: for the composition of the x,y,u,o,aux matrices, see help for yeast_simcon.m function

global citac_spusteni_reg
global t_inc
global dose

ut=zeros(1,3);
auxt=zeros(1,5)*NaN;
auxt_labels={'auxiliary variable no. 1','auxiliary variable no. 2','auxiliary variable no. 3','auxiliary variable no. 4','auxiliary variable no. 5'};


% air flowrate set to a constant value of 10 l/min, i.e. 167 ml/s
ut(2)=167;

% stirrer speed set to a constant value of 600 1/min, i.e. 10 1/s
ut(3)=10;

% feed flowrate - initial value (ml/min)
dose_initial=0.6;

% feed flowrate - increment (ml/min)
dose_delta=0.3;

% feed flowrate - upper limit (ml/min)
dose_max=5;

if i==1
	t_inc=i;
	dose=dose_initial;
end

% DO change threshold (% saturation)
DO_delta=0.1;

DO_current=y(i,4);
if (i>1)
DO_previous=y(i-1,4);
else
DO_previous=DO_current;
end

DO_dif=DO_current-DO_previous;

if DO_dif>DO_delta/2
	gain=DO_dif/DO_delta;
	dose=min([dose+gain*dose_delta dose_max]);
	on=1;
else
	on=1;
end

ut(1)=on*dose/60;
citac_spusteni_reg=citac_spusteni_reg+1;

% safety check against overfilling of the bioreactor

% maximum total allowable volume of liquid in the bioreactor (ml)
vol_max=7500;

cur_vol=x(i,6);
new_vol=cur_vol+ut(1)*60;

if new_vol>vol_max
	ut(1)=(vol_max-cur_vol)/60;
end


