function indicators=yield_prod_calc(cas,x,y,u,csi)

% Function for calculating substrate yield and process productivity
%
% indicators=yield_prod_calc(cas,x,y,u,csi)
%
% indicators(1) = yield ... yield of biomass obtained on the supplied substrate (gX/gS)
% indicators(2) = prod ... cultivation productivity (gX/l/h)
%
% cas ... column vector of sample times (min)
% x ... matrix of state variables
% y ... matrix of output (measured) variables
% u ... matrix of manipulated variables
% csi ... glucose concentration in the feed (mol/ml) 

% molar mass of biomass (g/l)
Mx=25.17;

% molar mass of glucose (g/l)
Ms=30;

% sample time (s)
sample_time=(cas(2)-cas(1))*60;

% nominal volume of the bioreactor (l)
Vr=7.5;

% duration of cultivation (h)
t_end=cas(end)/60;

sub_fed=sample_time/2*(u(1,1)+u(end,1)+2*sum(u(2:end-1,1)));
glucose=sub_fed*csi*Ms;
biomass=(x(end,1)*x(end,6)-x(1,1)*x(1,6))*Mx;

yield=biomass/glucose;
% prod=biomass/Vr/t_end;
prod=(x(end,1)-x(1,1))*1000*Mx/t_end;

indicators(1)=yield;
indicators(2)=prod;
