function odhad=odhad_softsens(i,t,x,y,u,ts,csi)

% odhad=odhad_softsens(i,t,x,y,u,ts,csi)
%
% odhad(1) ... estimation of biomass concentration value (mol/ml) from consumption and production rates (O2, CO2, substrate)
% odhad(2) ... estimation of biomass concentration value (mol/ml) from cumulative O2 consumption
%
% i ... integer index value passed from the parent FOR loop
% t ... current time (s)
% x ... matrix of state variables
% y ... matrix of output (measured) variables
% u ... matrix of manipulated variables
% ts ... sample time (s)
% csi ... glucose concentration in the feed (mol/ml)

global odhad_cx0

% estimation of biomass concentration value (mol/ml)

% initialization of the estimate calculation (simulation of the uncertainty of the estimate of the initial amount of biomass in the bioreactor (error +-50%)

if t==0
	r=-0.5+(0.5+0.5)*rand;
	odhad_cx0=(1+r)*x(1,1);
end

% calculation of biomass concentration estimation using soft sensors 

if t==0
	cx_softsens1=odhad_cx0;
	cx_softsens2=odhad_cx0;
else
	cx_softsens1=biomass_softsens_rates([odhad_cx0*x(1,6) y(i-1,2) y(i-1,3) ts u(i-1,1) csi x(i-1,6) u(i-1,2)]);

	cx_softsens2=biomass_softsens_coc([odhad_cx0*x(1,6) y(i-1,2) y(i-1,3) ts x(i-1,6) u(i-1,2)]);

end

odhad(1)=cx_softsens1;
odhad(2)=cx_softsens2;




