function yout=merson(t1,t2,accur,hh,hmax,hmin,y0,u,par)

%
% ODE solver (Merson's modification of the Runge-Kutta method)
%
% yout=merson(t1,t2,accur,hh,hmax,hmin,y0,u,par)
%
% t1 ... start time (s)
% t2 ... end time (s)
% accur ... required accuracy of the numerical solution
% hh ... initial step (s)
% hmax ... maximum step (s)
% hmin ... minimum step (s)
% y0 ... row vector of state variables values at time t1, i.e. initial condition
% u ... row vector of manipulated variables values at time t1
% par ... row vector of system parameters values at time t1
% 

x=t1;
flag=1;
kk=0;
kkk=0;
n=length(y0);
yout=y0;

pp=(t2-t1)/abs(t2-t1);
hh=abs(hh)*pp;

if (abs(hh)<abs(hmin)) 
	hh=abs(hmin)*pp;
end

if (abs(t2-t1)<=abs(hh)) h=t2-t1;
else h=hh;
end

while (flag==1) 
	if (abs(h)>abs(hmax))
		h=abs(hmax)*pp;
	end
	if (abs(h)>=abs(hmin)*0.999)
		if (kk~=0) 
			kk=0;
		end
	else 
		if (kkk~=1)
			if (kk~=1)
				kk=1;
			end
			h=abs(hmin)*pp;
			if (abs(x-t2)<abs(h))
				h=t2-x;
			end
		end
	end
y=yout;

s=f(x,y,u,par);
yk=h*s/3;
y=yout+yk;

s=f(x+h/3,y,u,par);
yk2=h*s/3;
y=yout+0.5*(yk+yk2);

s=f(x+h/3,y,u,par);
yk2=h*s/3;
y=yout+0.375*yk+1.125*yk2;

s=f(x+h/2,y,u,par);
yk3=h*s/3;
y=yout+1.5*yk+6*yk3-4.5*yk2;

s=f(x+h,y,u,par);
e=0.0000001*accur;

for i=1:n
	p=abs(0.2*(yk(i)+4*yk3(i)-4.5*yk2(i)-0.5*s(i)*h/3));
	if (p>e) 
		e=p;
	end
end

if ((e>=accur) & (kk~=1))
	kkk=0;
	h=0.8*h*(accur/e)^0.2;
else 
	yout=yout+0.5*(yk3*4+yk+h*s/3);
	if (kkk==1) 
		flag=0;
	else 
		x=x+h;
		p=0.8*(accur/e)^0.2;
		h=10*h;
		if (p<10)
			h=h*p/10;
		end
		hh=h;
		if (abs(x-t2)<abs(h))
			h=t2-x;
			if (abs(h)<=abs(hmax))
						kkk=1;
			end
		end
	end
end
end
