function p=get_par(x,u)


% Function for setting system parameters
% 
% p=get_par(x,u)
% 
% p...row vector of system parameters
%
% x...row vector of state variables
% u...row vector of manipulated variables

np=41;	% number of system parameters

p=zeros(1,np);

p(1)=55500e-6;	% cl (mol/cm3)
p(2)=40.4e-6;	% cg (mol/cm3)
p(3)=1e+8;	% He (Pa)
p(4)=4.81e+9;	% Ho (Pa)
p(5)=1.88e+8;	% Hc (Pa)
p(6)=0.152;	% Dr (m)
p(7)=0.07;	% Ds (m)
p(8)=5.5;	% Pno (1)
p(9)=1000e-6;	% ro (kg/cm3)
p(10)=101325;	% Patm (Pa)

p(11)=4*u(2)*1e-6/(p(6)^2);	% Vgas (m/s)
p(12)=pg(x,u,p);		% Pg (W)

p(13)=0;	% cxi (mol/cm3)
p(14)=9500e-6;% csi (mol/cm3)
p(15)=0;	% cei (mol/cm3)
p(16)=0.22e-6;	% coi (mol/cm3)
p(17)=0;	% cci (mol/cm3)
p(18)=0;	% ceig (mol/cm3)
p(19)=8.43e-6;	% coig (mol/cm3)
p(20)=0.004e-6;	% ccig (mol/cm3)
p(21)=2.94/3600;	% qs,max (1/s)
p(22)=0.22/3600;	% qe,max (1/s)
% p(23)=0.20/3600;	% qo,max (1/s)
p(23)=0.20/3600;
p(24)=5.67e-6;		% aks (mol/cm3)
p(25)=10.87e-6;		% ake (mol/cm3)
p(26)=0.0094e-6;	% ako (mol/cm3)
p(27)=-0.584;		% y1xs (molX/molS)
p(28)=-0.083;		% y2xs (molX/molS)
p(29)=-0.658;		% y3xe (molX/molE)
p(30)=23e-3;	% Me (kg/mol)
p(31)=781e-6;	% roe(t=30 C) (kg/cm3)
p(32)=30e-3;	% Ms (kg/mol)
p(33)=25.17e-3;	% Mx (kg/mol)
p(34)=32e-3;	% Mo2 (kg/mol)
p(35)=44e-3;	% Mc2 (kg/mol)
p(36)=0.10/3600;	% qo,min (1/s)
p(37)=0.1*1e-6/p(32);	% Kis (mol/cm3)
p(38)=46*1e-6/p(30);	% Kie (mol/cm3)
p(39)=0.05*3600;	% tsuppress (s)
p(40)=72*3600;		% tadapt (s)
p(41)=1.5*3600;		% t0 (s)
