function yout=f(t,x,u,p)

% Function for calculating the vector of the right sides of the state equations  dx/dt=f(t,x,u,p) according to the well-known theory of limited respiratory capacity developed by (Sonnleitner and Kppeli, 1986) and (Sonnleitner and Hahnemann, 1994)
%
% yout=f(t,x,u,p)
%
% yout...row vector of derivatives of state variables with respect to time dx/dt
% t...current time (s)
% x...row vector of state variables
% u...row vector of manipulated variables
% p...row vector of system parameters

yout=zeros(1,length(x));

cx=x(1);
cs=x(2);
ce=x(3);
co=x(4);
cc=x(5);
vt=x(6);
qocap=x(7);
help=x(8);
sup=x(9);

qo=qocap*co/(co+p(26))*p(38)/(ce+p(38));
qs=p(21)*cs/(cs+p(24));
qe=p(22)*ce/(ce+p(25))*p(37)/(cs+p(37));

qs1=min([qo/(1+1.05*p(27)) qs]);
qs2=qs-qs1;
qe3=min([(qo-(1+1.05*p(27))*qs1)/(1.5+1.05*p(29)) qe]);

rs1=-qs1*cx;  
rx1=p(27)*rs1;
ro1=(1+1.05*p(27))*rs1;
rc1=(-1-p(27))*rs1;

rs2=-qs2*cx;   
rx2=p(28)*rs2;
re2=(-2/3-0.7*p(28))*rs2;
rc2=(-1/3-0.3*p(28))*rs2;

re3=-qe3*cx;   
rx3=p(29)*re3;
ro3=(1.5+1.05*p(29))*re3;
rc3=(-1-p(29))*re3;

rx=rx1+rx2+rx3;
rs=rs1+rs2;
re=re2+re3;
ro=ro1+ro3;
rc=rc1+rc2+rc3;

mee=rx/cx;

indic=-help-sup;

if indic>=0
	kon1=1/p(40);
else
	kon1=mee;
end

qoul=p(23)*min([max([0 1+sup+help]) 1]);
qodes=(1+1.05*p(27))*qs+(1.5+1.05*p(29))*qe;

if qocap>=qodes & qocap<=qoul
	kon2=mee;
elseif qocap>=qodes & qocap>qoul
	kon2=1/p(39);
else
	kon2=1/p(41);
end

akla=0.026*((p(12)*1e+6)/vt)^0.4*p(11)^0.5;

cew=(u(2)*p(18)/vt+akla*ce)/(u(2)*p(2)*p(3)/(vt*p(1)*p(10))+akla);
cow=(u(2)*p(19)/vt+akla*co)/(u(2)*p(2)*p(4)/(vt*p(1)*p(10))+akla);
ccw=(u(2)*p(20)/vt+akla*cc)/(u(2)*p(2)*p(5)/(vt*p(1)*p(10))+akla);

vvi=u(1);

yout(1)=rx+vvi/vt*(p(13)-cx);
yout(2)=rs+vvi/vt*(p(14)-cs);
yout(3)=re+vvi/vt*(p(15)-ce)+akla*(cew-ce);
yout(4)=ro+vvi/vt*(p(16)-co)+akla*(cow-co);
yout(5)=rc+vvi/vt*(p(17)-cc)+akla*(ccw-cc);
yout(6)=vvi;
yout(7)=kon2*(-qocap+max([min([qodes qoul]) p(36)]));
yout(8)=kon1*(-help-sup);
yout(9)=1/p(39)*(p(38)/(p(38)+ce)-1-sup);

