function cx_est=biomass_softsens_rates(invar)

%
% Calculation of yeast biomass concentration estimation
% 
%
% cx_est=biomass_softsens_rates(invar)
% 
%
% Output variables
%
% cx_est - estimated yeast biomass concentration [mol/ml]
%
% Input variables
%
% invar(1)	x_est0 - estimate of the initial yeast biomass [mol]
% invar(2)	o2 [% mol]
% invar(3)	co2 [% mol]
% invar(4)	dtime - sample time [s]
% invar(5)	glu_feedrate - glucose feedrate [ml/s]
% invar(6)	csi - glucose concentration in the feed [mol/ml]
% invar(7)	v - broth volume in the bioreactor [ml]
% invar(8)	Fg - air flowrate to the bioreactor [ml/s]

global old_x_est

x_est0=invar(1);
o2=invar(2);
co2=invar(3);
dtime=invar(4);
glu_feedrate=invar(5);
csi=invar(6);
v=invar(7);
Fg=invar(8);

if isempty(old_x_est)
	old_x_est=x_est0;
end

% gi - air flowrate to the bioreactor [m3/h]
gi=Fg/1e6*3600;

% M_air	[g/mol] - molecular weight of air
M_air=28.97;

% ro_dryair [g/m3] - density of dry air at 20 C and 101.325 kPa
ro_air=1204.1;

% phi - air flowrate to the bioreactor [mol/h]
phi=gi*ro_air/M_air;

xo=o2/100;
xc=co2/100;
our=max([phi*(0.20945*xc+0.99967*xo-0.20945)/(xc+xo-1) 0]);
cpr=max([phi*(0.79055*xc+0.00033*xo-0.00033)/(1-xc-xo) 0]);
gfr=csi*glu_feedrate*3600;

% biomass increment estimate [mol]
dx_est=dtime/3600*(2.17*our-3.26*cpr+0.91*6.52/6*gfr);

% biomass estimate [mol]
x_est=old_x_est+dx_est;
old_x_est=x_est;

% biomass concentration estimate [mol/ml]
cx_est=x_est/v;







