function cx_est=biomass_softsens_coc(invar)

%
% Calculation of yeast biomass concentration estimation
% 
%
% cx_est=biomass_softsens_coc(invar)
% 
%
% Output variables
%
% cx_est - estimated yeast biomass concentration [mol/ml]
%
% Input variables
%
% invar(1)	x_est0 - estimate of the initial yeast biomass [mol]
% invar(2)	o2 [% mol]
% invar(3)	co2 [% mol]
% invar(4)	dtime - sample time [s]
% invar(5)	v - broth volume in the bioreactor [ml]
% invar(6)	Fg - air flowrate to the bioreactor [ml/s]

x_est0=invar(1);
o2=invar(2);
co2=invar(3);
dtime=invar(4);
v=invar(5);
Fg=invar(6);

% gi - air flowrate to the bioreactor [m3/h]
gi=Fg/1e6*3600;

% M_air	[g/mol] - molecular weight of air
M_air=28.97;

% ro_dryair [g/m3] - density of dry air at 20 C and 101.325 kPa
ro_air=1204.1;

% phi - air flowrate to the bioreactor [mol/h]
phi=gi*ro_air/M_air;

% our, cpr - oxygen uptake and carbon dioxide production rate [mol/h]
xo=o2/100;
xc=co2/100;
our=max([phi*(0.20945*xc+0.99967*xo-0.20945)/(xc+xo-1) 0]);
cpr=max([phi*(0.79055*xc+0.00033*xo-0.00033)/(1-xc-xo) 0]);

% coc - cumulative oxygen consumption [mol]

global old_coc
global old_our

if isempty(old_coc)
	old_coc=0;
end

if isempty(old_our)
	old_our=our;	
end

delta_coc=dtime/3600*(our+old_our)/2;
coc=delta_coc+old_coc;
old_our=our;
old_coc=coc;

% biomass increment estimate [mol]
% kcal=0.661;

kcal=1.27;
dx_est=kcal*coc;

% biomass estimate [mol]
x_est=dx_est+x_est0;

% biomass concentration estimate [mol/ml]
cx_est=x_est/v;








